<?php

namespace apexl\Io\modules\formbuilder\Components;

use apexl\Io\modules\component\Component\Component;
use apexl\Io\modules\formbuilder\Interfaces\FormComponent;
use apexl\Io\modules\formbuilder\Traits\HasFormChildren;
use apexl\Io\modules\formbuilder\Traits\HasFormIdProperty;

readonly class Fieldset extends Component implements FormComponent
{
    use HasFormIdProperty;
    use HasFormChildren;

    public function setLegend(string $title): static
    {
        return $this->setProperty('legend', $title);
    }

    public function addComponent(Component $component): static
    {
        if ($component instanceof FormComponent && $this->getFormId()) {
            $component->setFormId($this->getFormId());
        }

        parent::addComponent($component);

        return $this;
    }
}
