<?php

declare(strict_types=1);

namespace apexl\Io\modules\formbuilder\FormKitValidation;

use apexl\dto\Dto;

final readonly class FormKitValidation extends Dto
{
    public function __construct(
        public string $name,
        public string $config = '',
    ) {}

    public static function required(): FormKitValidation
    {
        return self::create('required');
    }

    public static function create(string $validation, string $config = ''): FormKitValidation
    {
        return new FormKitValidation($validation, $config);
    }

    /**
     * @param string $dateAfter YYYY-MM-DD format
     */
    public static function dateAfter(string $dateAfter): FormKitValidation
    {
        return self::create('date_after', $dateAfter);
    }

    /**
     * @param string $dateBefore YYYY-MM-DD format
     */
    public static function dateBefore(string $dateBefore): FormKitValidation
    {
        return self::create('date_before', $dateBefore);
    }

    public static function email()
    {
        return self::create('email');
    }

    public function toString(): string
    {
        return sprintf('%s%s', $this->name, $this->config ? sprintf(':%s', $this->config) : '');
    }
}