<?php

declare(strict_types=1);

namespace apexl\Io\modules\formbuilder\Traits;

use apexl\Io\modules\component\Component\Component;
use apexl\Io\modules\formbuilder\Interfaces\FormComponent;

trait HasFormChildren
{
    public function addComponent(Component $component): static
    {
        if ($component instanceof FormComponent && $this->getFormId()) {
            $component->setFormId($this->getFormId());
        }

        parent::addComponent($component);

        return $this;
    }

    abstract public function getFormId(): ?string;

}

