<?php

declare(strict_types=1);

namespace apexl\Io\modules\formbuilder\Traits;

trait HasFormIdProperty
{
    public final const string PROP__FORM_ID = 'formId';

    public function setFormId(string $formId): static
    {
        return $this->setProperty(self::PROP__FORM_ID, $formId);
    }

    abstract public function setProperty(string $name, mixed $value): static;

    public function getFormId(): ?string
    {
        return $this->getProperty(self::PROP__FORM_ID)->value;
    }

    abstract public function getProperty(string $name): mixed;

}

