<?php

declare(strict_types=1);

namespace apexl\Io\modules\formbuilder\Traits;

trait HasPlaceholderProperty
{
    public final const string PROP__PLACEHOLDER = 'placeholder';

    public function setPlaceholder(string $title): static
    {
        return $this->setProperty(self::PROP__PLACEHOLDER, $title);
    }

    abstract public function setProperty(string $name, mixed $value): static;
}

