<?php

declare(strict_types=1);

namespace apexl\Io\modules\formbuilder\Collections;

use apexl\Io\modules\formbuilder\FormKitValidation\FormKitValidation;
use Arrayy\Collection\AbstractCollection;

final class FormKitValidationCollection extends AbstractCollection
{

    public function getType(): string
    {
        return FormKitValidation::class;
    }

    public function toString(string $separator = '|'): string
    {
        return $this->map(fn(FormKitValidation $validation): string => $validation->toString())
            ->implode($separator);
    }
}