<?php

declare(strict_types=1);

namespace apexl\Io\modules\formbuilder\Traits;

trait HasOptionsProperty
{
    public function setOptions(array $options): static
    {
        $mappedOptions = array_map(
            fn(string|int $value, string|int $key): array => [
                'value' => $key,
                'label' => $value
            ],
            $options,
            array_keys($options)
        );

        $this->setProperty('options', $mappedOptions);

        return $this;
    }

    abstract public function setProperty(
        string $name,
        mixed $value,
    ): static;

}

