<?php

namespace apexl\Io\modules\formbuilder\Components\FormKitField;

use apexl\Io\modules\formbuilder\FormKitValidation\ValidationRule;

readonly class DatePickerFormKitField extends FormKitField
{
    protected final const string TYPE = 'datepicker';

    public function init(): void
    {
        $this->setMinDate(date('Y/m/d'));
        $this->setMaxDate(date('Y/m/d', (strtotime('+ 3 years'))));
    }

    public function setMinDate(string $min): static
    {
        return $this->addValidation(ValidationRule::dateAfter($min));
    }

    public function setMaxDate(string $max): static
    {
        return $this->addValidation(ValidationRule::dateBefore($max));
    }
}
