<?php

namespace apexl\Io\modules\geosimWebhooks\controllers;

use apexl\Config\Singleton;
use apexl\Io\includes\Utils;
use apexl\Utils\Xml\Convert;
use apexl\Vault\Vault;
use apexl\Io\includes\System;
use apexl\Io\services\pathUtility;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

class webhooksController {

    /** @var Singleton  */
    protected $config;

    /** @var Vault */
    protected $database;

    public function __construct(Singleton $config, Vault $database)
    {
        $this->config = $config;
        $this->database = $database;
    }

    public function smsConfigPost(Request $request, Response $response){
        $body = $request->getParsedBody();
        //build data stores
        $webhook = [
            "eventId" => $body['eventId'],
            "eventType" => $body['eventType'],
            "timestamp" => $body['timestamp'],
            "signature" => $body['signature'],
            "signature2" => $body['signature2'],
            "data" => $body['data'],
        ];
        $this->database->insert('jasper_webhooks')->fields($webhook)->execute();

        //Process XML
        $xml = Convert::processXml($body['data']);

        $sms = [
            "eventId" => $body['eventId'],
            "iccid" => $xml['iccid'] ?? null,
            "accountName" => $xml['accountName'] ?? null,
            "customerName" => $xml['customerName'] ?? null,
            "msisdn" => $xml['msisdn'] ?? null,
            "messageContent" => $xml['messageContent'] ?? null,
            "smppDataCoding" => $xml['smppDataCoding'] ?? null,
            "shortCode" => $xml['shortCode'] ?? null,
            "receivedTime" => $xml['receivedTime'] ?? null
        ];

        $this->database->insert('sms_mo_received')->fields($sms)->execute();

        return System::asJson($response, ['success' => true]);
    }

    public function smsConfigGetMessages(Request $request, Response $response, $args){
        //first get all the notices for the requested sim.
        //@todo add in an ownership check or some description
        $notices = $this->database->select('sms_mo_received')->fields()->where('iccid', $args['iccid'])->orderBy('id', 'DESC')->limit(20)->execute()->fetchAll();

        return System::asJson($response, ['data' => $notices]);
    }
}