<?php

namespace apexl\Io\modules\xero\controllers;

use apexl\Io\includes\Controller;
use apexl\Io\includes\System;
use apexl\Io\modules\display\includes\Forms;
use apexl\Io\modules\user\services\currentUser;
use apexl\Io\modules\xero\services\xeroService;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

class xeroController extends Controller {

    public function __construct()
    {
        parent::__construct();
    }

    public function viewInvoice(Request $request, Response $response, $args)
    {
        if (empty($args['id'])) {
            $this->output::addMessage('xero.viewInvoice', 'error','ID not provided');
            return System::asJson($response, [], 404);
        }

        $xero = new xeroService();
        $url = $xero->getInvoiceUrl($args['id']);

        if ($url) {
            $this->output::addMetadata(
                'xero.viewInvoice.post.redirect',
                'redirectToExternal',
                $url);
            return System::asJson($response);
        } else {
            $this->output::addMessage('xero.viewInvoice', 'error','Invoice could not be found');
            return System::asJson($response, [], 404);
        }
    }

    public function searchInvoices(Request $request, Response $response)
    {
        $user = currentUser::getCurrentUser();

        if (!($user->email ?? FALSE)) {
            die(); // No one logged in!
        } else $email = $user->email;

        $params = $request->getQueryParams();
        $email = $params['user_email'] ?? $user->email;

        $entityData['tableHeader'] = [
            'Invoice Number',
            'Email',
            'Invoice Date',
            'Reference',
            'Subtotal',
            'Tax',
            'Total',
            ''
        ];

        $xero = new xeroService();
        $entityData['rows'] = $xero->getInvoices($email);

        // Check for companyEmail
        if (class_exists('\apexl\Io\modules\company\entities\companyEntity')) { // If io-company is in use
            $companyEntity = new \apexl\Io\modules\company\entities\companyEntity();
            $companyEntity->loadByUser($user->id);
            if (isset($companyEntity->CompanyContactEmail) && trim($email) != trim($companyEntity->CompanyContactEmail)) {
                $entityData['rows'] = array_merge($entityData['rows'], $xero->getInvoices($companyEntity->CompanyContactEmail));
            }
        }

        if (empty($entityData['rows'])) {
            $entityData['tableHeader'] = [];
            $entityData['rows'][] = ['id' => 'No invoices on record'];
        }

        return System::asJson($response, $entityData);
    }

    public function brandingThemes(Request $request, Response $response)
    {
        $xeroService = new xeroService();
        $xeroService->getBrandingThemes();
    }

    public function accounts(Request $request, Response $response)
    {
        $xeroService = new xeroService();
        $xeroService->getAccounts();
    }

    public function testXero(Request $request, Response $response, $args){

        $xeroService = new xeroService();
        //$accounts = $xeroService->getAccounts();
        //$themes = $xeroService->getBrandingThemes();

        $lineItems = [
            (object)[
                'description' => 'Test Item',
                'quantity' => 10,
                'amount' => 50.00,
                'accountCode' => '860',
                'taxType' => 'OUTPUT2'
            ]
        ];
        $contactData = (object)[
            'name' => 'Mike Watson',
            'firstName' => 'Mike',
            'lastName' => 'Watson',
            'emailAddress' => 'mike@developmentx.uk',
            'taxNumber' => '3543646464'
        ];

        $xeroService->createInvoice($lineItems, $contactData, $dueDate = null, $desc = '', $branding = '5d4dd402-c851-497e-aae1-9ff265c0d15a', $type = 'ACCREC');

        // Test create invoice


        return System::asJson($response);
    }
}