<?php
namespace apexl\Io\modules\xero;

use apexl\Io\includes\Hook;
use apexl\Io\includes\Module;
use apexl\Io\modules\accessControl\callbacks\accessControl;
use apexl\Io\modules\accessControl\controllers\adminDisplayController;
use apexl\Io\modules\accessControl\controllers\formDisplayController;
use apexl\Io\modules\user\services\Permissions;
use apexl\Io\modules\userDisplay\controllers\userController;
use apexl\Io\modules\xero\controllers\xeroController;
use apexl\Io\modules\menu\services\Menu;
use apexl\Io\modules\user\classes\userManagedApiModule;

class xeroModule extends userManagedApiModule {

    public function __construct()
    {
        parent::__construct();
        //$this->registerHooks();
    }

    public function routes(){

        //Configuration Route
        $this->addProtectedActionRoute('GET', 'xero.test', 'xero/test', xeroController::class.':testXero', 'Invoicing');
        $this->addProtectedActionRoute('GET', 'xero.brandingthemes', 'xero/branding-themes', xeroController::class.':brandingThemes', 'Invoicing');
        $this->addProtectedActionRoute('GET', 'xero.accounts', 'xero/accounts', xeroController::class.':accounts', 'Invoicing');
        $this->addProtectedActionRoute('GET', 'xero.invoices.view', 'invoices/{id}', xeroController::class.':viewInvoice', 'Invoicing');

        // Data Routes
        $this->addProtectedDataRoute('GET', 'xero.invoices.get', 'search/invoices', xeroController::class.':searchInvoices', 'Invoicing');



    }

    public function registerPermissions(Permissions $permissions){
        $permissions->registerPermission('Invoicing', 'Access Invoicing', 'Invoicing');
    }

    public function registerCallbacks(){
        //Hook::registerCallback('accessControl', accessControl::class.':implement');
        //Hook::registerCallback('accessControlJoins', accessControl::class.':implementJoins');
        //Hook::registerCallback('accessControlClauses', accessControl::class.':implementClauses');
    }

    public function registerMenuItems(Menu $menu)
    {
        /*$menu::addToMenu('accessControl.configuration.ac.update', [
            'title' => 'Access Control',
            'weight' => - 10,
            'icon' => 'exclamation-triangle',
            'parent' => 'adminDisplay.configuration'
        ], 'administration');*/
    }


}