<?php

namespace apexl\Io\modules\xeroDisplay\controllers;

use apexl\Io\includes\Controller;
use apexl\Io\includes\Routes;
use apexl\Io\includes\System;
use apexl\Io\modules\display\components\EntityFilteredDisplayTable;
use apexl\Io\modules\display\includes\Forms;
use apexl\Io\modules\display\services\Render;
use apexl\Io\modules\user\services\currentUser;
use apexl\Io\modules\xero\services\xeroService;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

class xeroDisplayController extends Controller {

    protected $render;

    /**
     * bundleBuilderController constructor.
     * @param Render $render
     */
    public function __construct(Render $render){
        parent::__construct();
        $this->render = $render;
    }

    public function listInvoices(Request $request, Response $response, $args){


        $table = new EntityFilteredDisplayTable();
        $table->src(Routes::getRoutePattern('xero.invoices.get'));
        $table->displayPagination(FALSE);
        $table->displayShortTotals(FALSE);
        $table->hideIdColumn();
        $table->addButton('xero.invoices.view', 'eye', FALSE, TRUE);
        //$table->setFilters('Email='.$args['user_email']);
        $currentUser = currentUser::getCurrentUser();
        if ($currentUser->isAllowed('ViewAllAccounts')) {
            $table->addFilterForm('xeroDisplay.form.listInvoices.filter');
        }

        
        $this->render::setPageTitle('Invoices');
        $this->output::addResponse($request, $this->render::build([$table]));

        return System::asJson($response);

    }
}