<?php

namespace apexl\Io\modules\xeroDisplay\forms;

use apexl\Io\includes\System;
use apexl\Io\modules\formbuilder\entities\formEntity;
use apexl\Io\modules\formbuilder\includes\checkboxField;
use apexl\Io\modules\formbuilder\includes\inputField;
use apexl\Io\modules\formbuilder\includes\selectField;
use apexl\Io\modules\user\services\currentUser;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

class filters {

    public function invoices(Request $request, Response $response) {
        $form = new formEntity();
        $form->setId('invoiceListFilter');
        $form->setMethod('post');
        $form->setActionUrl('#');
        $form->setSubmitText('Filter');
        $form->includeClearButton(TRUE)->setClearButtonText('Reset');

        $currentUser = currentUser::getCurrentUser();

        //$form->addFieldToGroup((new inputField('KnownIccid'))->setLabel("Known ICCIDs only?")->addClass('col')->setPlaceholder('All'), 'Invoices');
        if($currentUser->isAllowed('ViewAllAccounts')) {
            $form->addFieldToGroup((new inputField('user_email'))->setLabel("Owner Email")->addClass('col')->setPlaceholder('Owner Email'), 'Invoices');
        }
        //$form->addFieldToGroup((new inputField('iccid'))->setLabel("ICCID")->addClass('col')->setPlaceholder('ICCID'), 'Invoices');
        //$form->addFieldToGroup((new selectField('KnownIccid', ['All' => 'All', 'Known' => 'Known', 'Unknown' => 'Unknown']))->setLabel("Known ICCIDs only?")->setPlaceholder('Select:')->addClass('col'), 'Invoices');
        //$form->addFieldToGroup((new checkboxField('TotalCharge'))->setLabel("Show Only With Overage?")->addClass('col'), 'Exceptions');
        //$form->addFieldToGroup((new checkboxField('IsBundleBuilder'))->setLabel("Hide Bundle Builder Entries?")->addClass('col'), 'Exceptions');
        //$form->addFieldToGroup((new checkboxField('isBilled'))->setLabel("Show Only Billed?")->addClass('col'), 'Exceptions');

        return System::asJson($response, $form->getBuiltFormArray());
    }

}