<?php
namespace apexl\Io\modules\xeroDisplay;

use apexl\Io\includes\Hook;
use apexl\Io\modules\display\controllers\displayController;
use apexl\Io\modules\menu\services\Menu;
use apexl\Io\modules\user\classes\userManagedDisplayModule;
use apexl\Io\modules\user\entities\roleEntity;
use apexl\Io\modules\user\entities\userEntity;
use apexl\Io\modules\userDisplay\callbacks\redirects;
use apexl\Io\modules\userDisplay\controllers\userController;
use apexl\Io\modules\userDisplay\controllers\rolesController;
use apexl\Io\modules\xeroDisplay\forms\filters;
use apexl\Io\modules\xeroDisplay\controllers\xeroDisplayController;

class xeroDisplayModule extends userManagedDisplayModule {
    public function __construct()
    {
        parent::__construct();
    }

    public function routes(){
        //Page routes.
        $this->addProtectedAdminRootRoute('GET', 'xero.display.invoicelist', 'invoice/list', xeroDisplayController::class.':listInvoices', 'Invoicing');

        //filters
        $this->addProtectedFormRoute('xeroDisplay.form.listInvoices.filter', 'listInvoices-filter', filters::class.':invoices', 'Invoicing');
    }

    /**
     * @param Menu $menu
     */
    public function registerMenuItems(Menu $menu)
    {
        $menu::addToMenu('xero.display.invoicelist', [
            'title' => 'Invoices',
            'icon' => 'receipt',
            'weight' => 25
        ]);
    }

}