<?php

namespace apexl\Io\modules\invoiceDisplay\components;

use apexl\Io\includes\Hook;
use apexl\Io\includes\Routes;
use apexl\Io\modules\display\components\BasicLink;
use apexl\Io\modules\display\components\CardEntityFilteredDisplayTable;
use apexl\Io\modules\display\components\ColWrapper;
use apexl\Io\modules\display\components\ContentTitle;
use apexl\Io\modules\display\components\DisplayTable;
use apexl\Io\modules\display\components\EntityFilteredDisplayTable;
use apexl\Io\modules\display\components\FormComponent;
use apexl\Io\modules\display\components\genericComponents;
use apexl\Io\modules\user\entities\roleEntity;
use apexl\Io\modules\user\entities\userEntity;
use apexl\Io\modules\user\services\currentUser;
use apexl\Io\modules\user\services\Permissions;

class dashboardTiles
{
    public static function userInvoicesTile($userEntity=null)
    {
        $helpComponents = [
            (new ContentTitle())->addClass('text-black text-start help-modal-content-title')->addTitle('A list of customer invoice'),
            (new DisplayTable())->addClass('text-black text-start help-modal-display-table')->addRows([
                ['Invoice Date', 'Date the Invoice was raised.'],
                ['Total', 'Total value of invoice, excluding VAT'],
                ['VAT', 'VAT due on the goods/services purchased'],
                ['Paid', 'Whether the invoice has been paid (yes/no)'],
                ['Last Payment Attempt', 'The last time an attempt was made to collect payment for this invoice'],
                ['Abandoned?', 'Whether this invoice has been marked as abandoned'],
            ])
        ];

        return (new ColWrapper())
            ->addClass('col-12')
            ->addComponent((new CardEntityFilteredDisplayTable())
                ->addTitle('Latest Invoices')
                ->src(Routes::getRoutePattern('invoice.data.basic'). (isset($userEntity->email) ? '?userEmail='.$userEntity->email : ''))
                ->displayPagination(false)
                ->displayShortTotals(false)
                ->addProperty('refreshButton', '<i class="fa-light fa-arrows-rotate"></i>')
                ->hideIdColumn()
                ->addHeaderModal('Latest Invoices Table', $helpComponents)
            );
    }

}