<?php
namespace apexl\Io\modules\invoice;

use apexl\Io\includes\System;
use apexl\Io\modules\invoice\controllers\invoiceController;
use apexl\Io\modules\invoice\controllers\webhookController;
use apexl\Io\modules\menu\services\Menu;
use apexl\Io\modules\user\classes\userManagedApiModule;
use apexl\Io\modules\user\services\Permissions;

class invoiceModule extends userManagedApiModule {
    protected $menu;

    public function __construct()
    {
        parent::__construct();
        $this->menu = Menu::getInstance();
    }

    public function routes() {

        //Configuration Route
        $this->addProtectedActionRoute('GET', 'provider.brandingthemes', 'provider/branding-themes', invoiceController::class.':brandingThemes', 'Invoicing');
        $this->addProtectedActionRoute('GET', 'provider.accounts', 'provider/accounts', invoiceController::class.':accounts', 'Invoicing');
        $this->addProtectedActionRoute('GET', 'provider.contactHistory', 'provider/contact-history/{type}/{identifier}', invoiceController::class.':contactHistory', 'Invoicing');
        $this->addProtectedActionRoute('GET', 'provider.invoices.view', 'provider/invoices/{id}', invoiceController::class.':viewInvoice', 'Invoicing');
        $this->addProtectedActionRoute('POST', 'invoice.webhook', 'webhook', webhookController::class.':processRequest', 'AllowAll');
        $this->addProtectedActionRoute('POST', 'provider.invoices.send', 'provider/invoice-send/{id}', invoiceController::class.':sendInvoiceToProvider', 'AllowAll');

        // Data Routes
        $this->addProtectedDataRoute('GET', 'provider.invoices.get', 'provider/search/invoices', invoiceController::class.':searchInvoices', 'Invoicing');
        $this->addProtectedDataRoute('get', 'invoice.data.basic', 'data/basic', invoiceController::class.':invoiceListTableDataBasic', 'ViewSubscriptions');
        $this->addProtectedDataRoute('get', 'invoice.subscription.data.basic', 'data/subscription/basic', invoiceController::class.':subscriptionInvoicesTableDataBasic', 'ViewSubscriptions');

        // Cron endpoints
        $this->addProtectedActionRoute('GET', 'subscription-billing.trigger.cron', 'subscription-billing/trigger/{cronKey}', invoiceController::class.':triggerSubscriptionInvoices');
        $this->addProtectedActionRoute('GET', 'payment.trigger.cron', 'payment/trigger/{cronKey}', invoiceController::class.':triggerInvoicePayments');
        $this->addProtectedActionRoute('GET', 'invoice.webhook.queue.process', 'webhook/queue/process/{cronKey}', webhookController::class.':processQueue');
        $this->addProtectedActionRoute('GET', 'invoice.paid.status.backfill', 'paid/status/backfill/{cronKey}', invoiceController::class.':backfillProviderPaidStatus');
        $this->addProtectedActionRoute('GET', 'paymentAlert.trigger.cron', 'payment-alerts/trigger/{cronKey}', invoiceController::class.':triggerPaymentAlerts');


    }

    public function schema(){
        return System::loadSchema(__DIR__.'/schema/schema.json');
    }
    public function registerPermissions(Permissions $permissions){
        $permissions->registerPermission('ViewInvoices', 'View own Invoices', 'Invoice');
        $permissions->registerPermission('Invoicing', 'Access Invoicing', 'Invoicing');
    }

    public function registerCallbacks(){

    }
}