<?php

namespace apexl\Io\modules\invoice\entities\operators;

use apexl\Io\operators\entityDatabaseOperator;

class invoiceOperator extends entityDatabaseOperator{

    public function __construct($table, $primaryKey = 'id')
    {
        parent::__construct($table, $primaryKey);
    }

    public function loadByProviderId($providerId) {
        $entity = $this->vault->select($this->dbTable)
            ->fields()
            ->where('provider_id', $providerId)
            ->execute()
            ->fetchAssoc();

        return ['updateEntityData' => true, 'data' => $entity];
    }

    public function loadByPaymentId($paymentId) {

        $invoicePayment = $this->vault->select('invoice_payment')
            ->fields()
            ->where('payment_id', $paymentId)
            ->execute()
            ->fetchAssoc();
        if ($invoicePayment) {

            $entity = $this->vault->select($this->dbTable)
                ->fields()
                ->where('id', $invoicePayment['invoice_id'])
                ->execute()
                ->fetchAssoc();

            return ['updateEntityData' => true, 'data' => $entity];
        }

        return null;
    }

    public function getChargeable($limit)
    {
        return $this->vault
            ->select($this->dbTable)
            ->fields()
            ->where('paid', 0)
            ->where('abandoned', 0)
            ->where('on_hold', 0)
            ->orderBy('last_payment_attempt', 'ASC')
            ->limit($limit)
            ->execute()
            ->fetchAll();

    }

    public function getOverdue($daysCutoff=3)
    {
        $date = new \DateTime('now');
        $date->sub(new \DateInterval('P3D'));

        return $this->vault
            ->select($this->dbTable)
            ->fields()
            ->where('paid', 0)
            ->where('abandoned', 0)
            ->where('invoice_date', $date->format('Y-m-d'), '<')
            ->where
            ->orderBy('last_payment_attempt', 'ASC')
            ->limit($limit)
            ->execute()
            ->fetchAll();
    }

    public function getForSubscription($subscriptionId)
    {
        return $this->vault
            ->select($this->dbTable)
            ->fields($this->dbTable.'.*')
            ->leftjoin('invoice_subscription', $this->dbTable.'.id=invoice_subscription.invoice_id', '','')
            ->where('subscription_id', $subscriptionId)
            ->execute()
            ->fetchAll();

    }

    public function getForUser($userId)
    {
        return $this->vault
            ->select($this->dbTable)
            ->fields($this->dbTable.'.*')
            ->where('user_id', $userId)
            ->execute()
            ->fetchAll();

    }
}