<?php

namespace apexl\Io\modules\invoiceDisplay\controllers;

use apexl\Config\Singleton;
use apexl\encryption\Encrypt;
use apexl\Io\includes\Controller;
use apexl\Io\includes\Routes;
use apexl\Io\includes\System;
use apexl\Io\modules\display\components\CardEntityFilteredDisplayTable;
use apexl\Io\modules\display\components\EntityFilteredDisplayTable;
use apexl\Io\modules\display\services\Render;
use apexl\Io\modules\invoice\services\invoiceService;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

class invoiceDisplayController extends Controller{

    protected $render;

    public function __construct(Render $render, invoiceService $invoiceService)
    {
        parent::__construct();
        $this->invoiceService = $invoiceService;
        $this->render = $render;
    }

    public function listInvoices(Request $request, Response $response, $args){

        $table = (new CardEntityFilteredDisplayTable())
            ->src(Routes::getRoutePattern('provider.invoices.get'))
            ->displayPagination(FALSE)
            ->displayShortTotals(FALSE)
            ->hideIdColumn()
            ->addTitle('Invoices')
            ->addButton('provider.invoices.view', 'eye', FALSE, TRUE)
            ->addFilterForm('invoiceDisplay.form.listInvoices.filter', null, 5, true, "Filter Invoices");


        $this->render::setPageTitle('Invoices');
        $this->output::addResponse($request, $this->render::build([$table]));

        return System::asJson($response);

    }

}