<?php

namespace apexl\Io\modules\invoice\entities\operators;

use apexl\Io\operators\entityDatabaseOperator;

class invoiceProcessQueueOperator extends entityDatabaseOperator{

    public function __construct($table, $primaryKey = 'id')
    {
        parent::__construct($table, $primaryKey);
    }

    public function getUnprocessedItems()
    {
        return $this->vault
            ->select($this->dbTable)
            ->fields()
            ->where('processed',NULL, "IS NULL")
            ->limit(5) // Keep small to avoid exceeding API limits
            ->execute()
            ->fetchAll();
    }

    public function markItemAsProcessed($providerId, $error="")
    {
        $fields = ['processed' => date('Y-m-d H:i:s')];
        if ($error) $fields['error'] = $error;
        $query = $this->vault->update($this->dbTable)->fields($fields)->where('provider_id', $providerId)->where('processed',NULL, "IS NULL")->execute();
    }

}