<?php
namespace apexl\Io\modules\invoiceDisplay;

use apexl\Io\modules\invoiceDisplay\controllers\invoiceDisplayController;
use apexl\Io\modules\invoiceDisplay\forms\filters;
use apexl\Io\modules\menu\services\Menu;
use apexl\Io\modules\user\services\Permissions;
use apexl\Io\modules\userDisplay\userDisplayModule;

class invoiceDisplayModule extends userDisplayModule {

    public function __construct()
    {
        parent::__construct();
    }

    public function routes() {
        $this->addProtectedAdminRootRoute('GET', 'invoice.display.invoicelist', 'invoice/list', invoiceDisplayController::class.':listInvoices', 'Invoicing');

        //filters
        $this->addProtectedFormRoute('invoiceDisplay.form.listInvoices.filter', 'listInvoices-filter', filters::class.':invoices', 'Invoicing');
    }

    public function registerPermissions(Permissions $permissions){
        $permissions->registerPermission('ViewInvoices', 'View own Invoices', 'Invoice');
    }

    public function registerCallbacks(){

    }

    /**
     * @param Menu $menu
     */
    public function registerMenuItems(Menu $menu)
    {
        $menu::addToMenu('invoice.display.invoicelist', [
            'title' => 'Invoices',
            'icon' => 'receipt',
            'weight' => 25
        ]);
    }
}