<?php

namespace apexl\Io\modules\invoice\controllers;

use apexl\Io\includes\Controller;
use apexl\Io\includes\Hook;
use apexl\Io\includes\Routes;
use apexl\Io\includes\System;
use apexl\Io\includes\Utils;
use apexl\Io\modules\invoice\services\webhookService;
use apexl\Io\modules\user\entities\userEntity;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

class webhookController extends Controller
{
    public function __construct()
    {
        parent::__construct();
    }

    public function processRequest(Request $request, Response $response)
    {
        $webhookService = new webhookService();
        list($statusCode, $error) = $webhookService->processRequest($request);

        if ($error) {
            return System::asJson($response, ['error' => $error], $statusCode);
        }

        return System::asJson($response);
    }

    public function processQueue(Request $request, Response $response)
    {
        $webhookService = new webhookService();
        $result = $webhookService->processQueue();

        return System::asJson($response, ['result' => $result.' queue records processed']);
    }
}
