<?php

namespace apexl\Io\modules\invoiceDisplay\forms;

use apexl\Io\includes\System;
use apexl\Io\modules\formbuilder\entities\formEntity;
use apexl\Io\modules\formbuilder\includes\checkboxField;
use apexl\Io\modules\formbuilder\includes\inputField;
use apexl\Io\modules\formbuilder\includes\selectField;
use apexl\Io\modules\user\services\currentUser;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

class filters {

    public function invoices(Request $request, Response $response) {
        $form = new formEntity();
        $form->setId('invoiceListFilter');
        $form->setMethod('post');
        $form->setActionUrl('#');
        $form->setSubmitText('Filter');
        $form->includeClearButton(TRUE)->setClearButtonText('Reset');

        $currentUser = currentUser::getCurrentUser();

        if($currentUser->isAllowed('ViewAllAccounts')) {
            $form->addFieldToGroup((new inputField('user_email'))->setLabel("Owner Email")->addClass('col')->setPlaceholder('Owner Email'), 'Invoices');
        }

        return System::asJson($response, $form->getBuiltFormArray());
    }

}