<?php

namespace apexl\Io\modules\invoice\entities\operators;

use apexl\Io\operators\entityDatabaseOperator;

class invoicePaymentOperator extends entityDatabaseOperator{

    public function __construct($table, $primaryKey = 'id')
    {
        parent::__construct($table, $primaryKey);
    }

    public function getPayments($invoiceId)
    {
        return $this->vault
            ->select($this->dbTable)
            ->fields('payment.*')
            ->join('payment', 'payment.id', $this->dbTable.'.payment_id')
            ->where($this->dbTable.'.invoice_id', $invoiceId)
            ->execute()
            ->fetchAll();
    }

    public function loadByPaymentId($paymentId) {

        $entity = $this->vault->select($this->dbTable)
            ->fields()
            ->where('payment_id', $paymentId)
            ->execute()
            ->fetchAssoc();

        return ['updateEntityData' => true, 'data' => $entity];
    }


}