<?php

namespace apexl\Io\modules\invoiceDisplay\components;

use apexl\Io\includes\Hook;
use apexl\Io\includes\Routes;
use apexl\Io\modules\display\components\BasicLink;
use apexl\Io\modules\display\components\ColWrapper;
use apexl\Io\modules\display\components\ContentTitle;
use apexl\Io\modules\display\components\DisplayTable;
use apexl\Io\modules\display\components\EntityFilteredDisplayTable;
use apexl\Io\modules\display\components\FormComponent;
use apexl\Io\modules\display\components\genericComponents;
use apexl\Io\modules\user\entities\roleEntity;
use apexl\Io\modules\user\entities\userEntity;
use apexl\Io\modules\user\services\currentUser;
use apexl\Io\modules\user\services\Permissions;

class dashboardTiles
{
    public static function userInvoicesTile($userEntity=null)
    {
        $InvoicesList = new ColWrapper();
        $InvoicesList->addClass('bg-white col-12');
        $InvoicesList->addTitle('Latest Invoices');
        $invoicesTable = new EntityFilteredDisplayTable();
        $invoicesTable->src(Routes::getRoutePattern('invoice.data.basic'). (isset($userEntity->email) ? '?userEmail='.$userEntity->email : ''));
        $invoicesTable->displayPagination(FALSE);
        $invoicesTable->displayShortTotals(FALSE);
        $invoicesTable->hideIdColumn();
        $InvoicesList->addComponent($invoicesTable);

        //build tile
        return $InvoicesList;
    }

}