<?php

declare(strict_types=1);

namespace apexl\Io\modules\jobs\Helper;

use apexl\Io\modules\jobs\Entity\QueueJob;
use apexl\Io\modules\jobs\Interface\QueueTaskInterface;

readonly final class QueueJobTask implements QueueTaskInterface
{
    public function __construct(private QueueJob $queueJob)
    {
    }

    public function lock(): void
    {
        $this->queueJob->lock();
    }

    public function unlock(): void
    {
        $this->queueJob->unlock();
    }

    public function markProcessed(): void
    {
        $this->queueJob->markProcessed();
    }

    public function run(): void
    {
        $this->queueJob->run();
    }

    public function name(): string
    {
        return sprintf('Queue Job %d', $this->queueJob->id);
    }

    public function handleFailure(): void
    {
        $this->queueJob->handleFailure();
    }

    public function isLocked(): bool
    {
        return $this->queueJob->locked;
    }
}
