<?php
declare(strict_types=1);

use Phinx\Db\Adapter\AdapterInterface;
use Phinx\Db\Table\Index;
use Phinx\Migration\AbstractMigration;

final class CreateJobQueueTable extends AbstractMigration
{
    /**
     * Change Method.
     *
     * Write your reversible migrations using this method.
     *
     * More information on writing migrations is available here:
     * https://book.cakephp.org/phinx/0/en/migrations.html#the-change-method
     *
     * Remember to call "create()" or "update()" and NOT "save()" when working
     * with the Table class.
     */
    public function change(): void
    {
        $this->table('job_queue')
            ->addColumn('sequence', AdapterInterface::PHINX_TYPE_INTEGER, [
                'signed' => false,
                'null' => false,
            ])
            ->addColumn('handler', AdapterInterface::PHINX_TYPE_STRING, [
                'null' => false,
            ])
            ->addColumn('created', AdapterInterface::PHINX_TYPE_DATETIME, [
                'null' => false,
            ])
            ->addColumn('locked', AdapterInterface::PHINX_TYPE_BOOLEAN, [
                'null' => false,
                'default' => false,
            ])
            ->addColumn('attempts', AdapterInterface::PHINX_TYPE_INTEGER, [
                'signed' => false,
                'null' => false,
                'default' => 0,
            ])
            ->addColumn('processed', AdapterInterface::PHINX_TYPE_DATETIME)
            ->addColumn('failed', AdapterInterface::PHINX_TYPE_DATETIME)
            ->addColumn('contents', AdapterInterface::PHINX_TYPE_TEXT, [
                'null' => false,
            ])
            ->addIndex(['handler', 'sequence'], [
                Index::UNIQUE => true,
            ])
            ->addIndex('created')
            ->addIndex('locked')
            ->addIndex('processed')
            ->create();
    }
}
