<?php

declare(strict_types=1);

namespace apexl\Io\modules\jobs\Service;

use apexl\entityCore\helpers\Condition;
use apexl\Io\modules\jobs\Entity\QueueJob;
use apexl\Io\modules\jobs\Helper\QueueJobTask;
use apexl\Io\modules\jobs\Interface\QueuedTaskFinderInterface;

class QueuedTaskFinderDb implements QueuedTaskFinderInterface
{
    public function tasks(int $limit = 10): array
    {
        $job = new QueueJob();

        $jobs = $job->loadMultiple([
            Condition::isNull('processed'),
            Condition::isNull('failed'),
            Condition::equals('locked', 0),
        ], ['sequence', 'ASC'], $limit);

        return array_map(fn(QueueJob $queueJob) => new QueueJobTask($queueJob), $jobs);
    }
}
