<?php

declare(strict_types=1);

namespace apexl\Io\modules\jobs\Controller;

use apexl\Io\includes\Controller;
use apexl\Io\includes\System;
use apexl\Io\modules\jobs\Service\TaskRunnerService;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;

final class QueueProcessController extends Controller
{

    public function __construct(readonly private TaskRunnerService $taskRunnerService)
    {
        parent::__construct();
    }

    public function __invoke(ServerRequestInterface $request, ResponseInterface $response): ResponseInterface
    {
        $this->taskRunnerService->run();

        return System::asJson($response);
    }
}
