<?php

declare(strict_types=1);

namespace apexl\Io\modules\jobs\Controller;

use apexl\Io\includes\Controller;
use apexl\Io\includes\System;
use apexl\Io\modules\jobs\RequestHelper\QueueProcessRequestHelper;
use apexl\Io\modules\jobs\Service\TaskRunnerService;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;

final class QueueProcessController extends Controller
{

    public function __construct(readonly private TaskRunnerService $taskRunnerService)
    {
        parent::__construct();
    }

    public function __invoke(
        ServerRequestInterface $request,
        ResponseInterface $response,
        array $args
    ): ResponseInterface {
        $requestHelper = QueueProcessRequestHelper::factory($request, $args);

        $this->taskRunnerService->run($requestHelper->limit());

        return System::asJson($response);
    }
}
