<?php

declare(strict_types=1);

namespace apexl\Io\modules\jobs\Hook;

use apexl\Io\collections\CommandCollection;
use apexl\Io\hooks\AbstractHook;
use apexl\Io\modules\jobs\Command\RunJobsCommand;

final readonly class ConsoleCommands extends AbstractHook
{
    protected static function hooks(): array
    {
        return ['consoleCommands'];
    }

    public function __invoke(CommandCollection $commands): CommandCollection
    {
        $commands->add(RunJobsCommand::class);

        return $commands;
    }
}
