<?php

declare(strict_types=1);

namespace apexl\Io\modules\jobs\Hook;

use apexl\Config\Singleton as Config;
use apexl\Io\hooks\AbstractHook;
use apexl\Io\modules\cron\cronModule;
use apexl\Io\modules\jobs\Service\TaskRunnerService;
use apexl\Io\modules\system\services\modules;
use GO\Scheduler;

final readonly class RegisterJobQueueCronJobHook extends AbstractHook
{
    public function __construct(private TaskRunnerService $taskRunnerService)
    {
    }

    static protected function hooks(): array
    {
        $hooks = [];

        if (self::shouldRegisterCronJob()) {
            $hooks[] = cronModule::HOOK__REGISTER_CRON_TASK;
        }

        return $hooks;
    }

    private static function shouldRegisterCronJob(): bool
    {
        return ((Config::getInstance()->jobs?->registerCronJob ?? false) === true) &&
            (modules::getInstance()->isInstalled('cron'));
    }

    public function __invoke(Scheduler $scheduler): void
    {
        $scheduler->call(function () {
            $this->taskRunnerService->run();
        }, [], 'Run IO Jobs')
            ->everyMinute();
    }
}
