<?php

declare(strict_types=1);

namespace apexl\Io\modules\jobs\Hook;

use apexl\Io\collections\DaedalusCommandCollection;
use apexl\Io\hooks\AbstractHook;
use apexl\Io\modules\jobs\Command\RunJobsCommand;

final readonly class ConsoleCommands extends AbstractHook
{
    protected static function hooks(): array
    {
        return ['consoleCommands'];
    }

    public function __invoke(DaedalusCommandCollection $commands): DaedalusCommandCollection
    {
        $commands->add(RunJobsCommand::class);

        return $commands;
    }
}
