<?php

declare(strict_types=1);

namespace apexl\Io\modules\jobs;

use apexl\Io\includes\Module;
use apexl\Io\includes\System;
use apexl\Io\interfaces\HasServicesInterface;
use apexl\Io\modules\jobs\Controller\QueueProcessController;
use apexl\Io\modules\jobs\Hook\ConsoleCommands;
use apexl\Io\modules\jobs\Hook\RegisterJobQueueCronJobHook;
use apexl\Io\modules\jobs\Interface\QueuedTaskFinderInterface;
use apexl\Io\modules\jobs\Service\QueuedTaskFinderDb;
use app\vendor\apexl\io\src\Io\interfaces\HasHooksInterface;

class jobsModule extends Module implements HasServicesInterface, HasHooksInterface
{
    public function routes(): void
    {
        $this->route->post(
            'jobs.queue.process',
            '/queue/process',
            QueueProcessController::class,
        );
    }

    public function hooks(): array
    {
        return [
            ConsoleCommands::class,
            RegisterJobQueueCronJobHook::class,
        ];
    }

    public function addServices(): array
    {
        return [
            QueuedTaskFinderInterface::class => fn() => System::makeRegisteredService(QueuedTaskFinderDb::class),
        ];
    }
}
