<?php

declare(strict_types=1);

namespace apexl\Io\modules\jobs\Controller;

use apexl\Io\includes\Controller;
use apexl\Io\modules\jobs\RequestHelper\QueueProcessRequestHelper;
use apexl\Io\modules\jobs\Service\TaskRunnerService;
use apexl\Io\services\Output;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;

final readonly class QueueProcessController extends Controller
{

    public function __construct(
        private TaskRunnerService $taskRunnerService,
        Output $output,
    ) {
        parent::__construct($output);
    }

    public function __invoke(
        ServerRequestInterface $request,
        ResponseInterface $response,
        array $args
    ): ResponseInterface {
        $requestHelper = QueueProcessRequestHelper::factory($request, $args);

        $this->taskRunnerService->run($requestHelper->limit());

        return $this->json($response);
    }
}
