<?php

declare(strict_types=1);

namespace apexl\Io\modules\jobs\Command;

use apexl\Io\modules\jobs\Service\TaskRunnerService;
use app\vendor\apexl\io\src\Io\modules\system\commands\DaedalusCommand;
use Symfony\Component\Console\Attribute\AsCommand;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

#[AsCommand(name: 'jobs:run', description: 'Run job queue')]
class RunJobsCommand extends DaedalusCommand
{
    public function __construct(
        private readonly TaskRunnerService $taskRunnerService
    ) {
        parent::__construct();
    }

    protected function configure(): void
    {
        parent::configure();

        $this->addOption('limit', 'l', InputOption::VALUE_OPTIONAL, 'The number of jobs to process', 10);
    }

    protected function execute(InputInterface $input, OutputInterface $output): int
    {
        $this->taskRunnerService->run($input->getOption('limit'));

        return 0;
    }
}
