<?php

declare(strict_types=1);

namespace apexl\Io\modules\jobs\Hook;

use apexl\Io\interfaces\AbstractHook;
use apexl\Io\modules\cron\cronModule;
use apexl\Io\modules\jobs\Service\TaskRunnerService;
use apexl\Io\modules\system\services\ModuleManager;
use GO\Scheduler;

final readonly class RegisterJobQueueCronJobHook implements AbstractHook
{
    public function __construct(private ModuleManager $moduleManager) {}

    public function hooks(): array
    {
        $hooks = [];

        if ($this->shouldRegisterCronJob()) {
            $hooks[] = cronModule::HOOK__REGISTER_CRON_TASK;
        }

        return $hooks;
    }

    private function shouldRegisterCronJob(): bool
    {
        return (config('jobs.registerCronJob', false) === true) &&
            $this->moduleManager->isInstalled(cronModule::class);
    }

    public function __invoke(Scheduler $scheduler, TaskRunnerService $taskRunnerService): void
    {
        $scheduler->call(fn() => $taskRunnerService->run(), [], 'Run IO Jobs')
            ->everyMinute();
    }
}
