<?php
declare(strict_types=1);

use Phinx\Db\Adapter\AdapterInterface;
use Phinx\Db\Adapter\MysqlAdapter;
use Phinx\Migration\AbstractMigration;

final class MakeJobQueueContentsMediumText extends AbstractMigration
{
    /**
     * Change Method.
     *
     * Write your reversible migrations using this method.
     *
     * More information on writing migrations is available here:
     * https://book.cakephp.org/phinx/0/en/migrations.html#the-change-method
     *
     * Remember to call "create()" or "update()" and NOT "save()" when working
     * with the Table class.
     */
    public function up(): void
    {
        $this->table('job_queue')
            ->changeColumn('contents', AdapterInterface::PHINX_TYPE_TEXT, [
                'null' => false,
                'length' => MysqlAdapter::TEXT_MEDIUM,
            ])
            ->update();

    }

    public function down(): void
    {
        $this->table('job_queue')
            ->changeColumn('contents', AdapterInterface::PHINX_TYPE_TEXT, [
                'null' => false,
            ])
            ->update();

    }
}
