<?php

declare(strict_types=1);

namespace apexl\Io\modules\jobs\Controller;

use apexl\Io\includes\Controller;
use apexl\Io\modules\jobs\RequestHelper\QueueProcessRequestHelper;
use apexl\Io\modules\jobs\Service\TaskRunnerService;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;

final readonly class QueueProcessController extends Controller
{
    public function __invoke(
        TaskRunnerService $taskRunnerService,
        ServerRequestInterface $request,
        ResponseInterface $response,
        QueueProcessRequestHelper $requestHelper,
    ): ResponseInterface {
        $taskRunnerService->run($requestHelper->limit());

        return $this->json($response);
    }
}
