<?php

declare(strict_types=1);

namespace apexl\Io\modules\jobs\Controller;

use apexl\Io\includes\Controller;
use apexl\Io\modules\jobs\Request\QueueProcessRequest;
use apexl\Io\modules\jobs\Service\TaskRunnerService;
use JsonException;
use Psr\Http\Message\ResponseInterface;

final readonly class QueueProcessController extends Controller
{
    /**
     * @throws JsonException
     */
    public function __invoke(
        TaskRunnerService $taskRunnerService,
        QueueProcessRequest $request,
        ResponseInterface $response,
    ): ResponseInterface {
        $taskRunnerService->run($request->limit());

        return $this->json($response);
    }
}
