<?php

declare(strict_types=1);

namespace apexl\Io\modules\jobs\Factory;

use apexl\Io\modules\jobs\Entity\QueueJob;
use apexl\Vault\Vault;
use DateTimeImmutable;
use DI\Container;

final readonly class QueueJobFactory
{
    public function __construct(private Container $container, private Vault $db) {}

    public function make(
        string $handler,
        mixed $contents,
        string|int|null $sequence = null,
        ?DateTimeImmutable $created = null,
    ): QueueJob {
        $job = $this->container->make(QueueJob::class);

        $job->sequence = $sequence ?? $this->nextSequence();
        $job->handler = $handler;
        $job->created = $created ?? new DateTimeImmutable();
        $job->contents = $contents;
        $job->store();

        return $job;
    }

    public function nextSequence(): int
    {
        return (int) $this->db
            ->select('job_queue')
            ->fields(['(IFNULL(MAX(sequence),0) + 1) AS sequence'])
            ->execute()
            ->fetch()->sequence;
    }

}