<?php

declare(strict_types=1);

use Phinx\Db\Table\Index;
use Phinx\Migration\AbstractMigration;

final class SwapOrderOfIndexInJobQueue extends AbstractMigration
{
    public function up(): void
    {
        $this->table('job_queue')
            ->removeIndex(['handler', 'sequence'])
            ->addIndex(['sequence', 'handler'], [Index::UNIQUE => true])
            ->update();
    }

    public function down(): void
    {
        $this->table('job_queue')
            ->addIndex(['handler', 'sequence'])
            ->removeIndex(['sequence', 'handler'], [Index::UNIQUE => true])
            ->update();
    }
}
