<?php

declare(strict_types=1);

namespace apexl\Io\modules\jobs;

use apexl\Io\includes\Module;
use apexl\Io\includes\RouteManager;
use apexl\Io\modules\jobs\Controller\QueueProcessController;
use apexl\Io\modules\jobs\Hook\ConsoleCommands;
use apexl\Io\modules\jobs\Hook\RegisterJobQueueCronJobHook;
use apexl\Io\modules\system\interfaces\ProvidesRoutesInterface;
use app\vendor\apexl\io\src\Io\interfaces\ProvidesHooksInterface;

class jobsModule extends Module implements ProvidesHooksInterface, ProvidesRoutesInterface
{
    public function routes(RouteManager $routeManager): void
    {
        $routeManager->post(
            'jobs.queue.process',
            '/queue/process',
            QueueProcessController::class,
        );
    }

    public function hooks(): array
    {
        return [
            ConsoleCommands::class,
            RegisterJobQueueCronJobHook::class,
        ];
    }
}
