<?php

declare(strict_types=1);

namespace apexl\Io\modules\logger\notifiers;

use apexl\Io\modules\logger\interfaces\loggerInterface;
use apexl\Io\modules\notifier\interfaces\notifierInterface;
use apexl\Io\modules\notifier\notifiers\notifier;

/**
 * @TODO Lift this out into a separate module, requiring `apexl/io-logger` and `apexl/io-notifer`
 */
abstract class loggerNotifier extends notifier implements notifierInterface
{
    protected loggerInterface $logger;
    abstract protected function message(): string;

    public function __construct()
    {
        parent::__construct();
    }

    public function send(): void
    {
        $this->logger->debug($this->message(), $this->context());
    }

    protected function context(): array
    {
        return [];
    }
}
