<?php

declare(strict_types=1);

namespace apexl\Io\modules\logger\listeners;

use apexl\Io\includes\Hook;
use apexl\Io\modules\logger\traits\getsSimpleTrace;
use Exception;

class errorListener
{
    use getsSimpleTrace;

    private const HOOK = 'error';

    public static function register()
    {
        Hook::registerCallback(
            self::HOOK,
            sprintf('%s:handle', errorListener::class)
        );
    }
    public static function handle(Exception $e): void
    {
        logger('error')->error($e->getMessage(), ['trace' => self::simpleTrace($e->getTrace())]);
    }
}
