<?php

declare(strict_types=1);

namespace apexl\Io\modules\logger;

use apexl\Io\includes\Module;
use apexl\Io\modules\logger\dto\loggerConfig;
use apexl\Io\modules\logger\listeners\errorListener;
use apexl\Io\modules\logger\listeners\whoopsHandlerListener;
use Exception;

class loggerModule extends Module
{
    public function __construct()
    {
        parent::__construct();

        try {
            $this->config = loggerConfig::fromConfig();
        } catch (Exception $e) {
            user_error($e->getMessage(), E_USER_ERROR);
        }

        $this->registerHooks();
    }

    private function registerHooks()
    {
        if ($this->config->catchErrors) {
            whoopsHandlerListener::register();
            errorListener::register();
        }
    }
}
