<?php

declare(strict_types=1);

namespace apexl\Io\modules\logger\listeners;

use apexl\Io\includes\Hook;
use apexl\Io\modules\logger\traits\getsSimpleTrace;
use Throwable;

class errorListener
{
    use getsSimpleTrace;

    private const HOOK = 'error';

    public static function register(): void
    {
        Hook::registerCallback(
            self::HOOK,
            sprintf('%s:handle', errorListener::class)
        );
    }

    public static function handle(Throwable $e): void
    {
        logger('error')->error(sprintf('%s: %s', $e::class, $e->getMessage()), [
            'trace' => self::simpleTrace($e->getTrace()),
        ]);
    }
}
