<?php

declare(strict_types=1);

namespace apexl\Io\modules\logger\hooks;

use apexl\Io\hooks\AbstractHook;
use apexl\Io\modules\logger\whoops\handlers\ioLoggerHandler;

final readonly class whoopsHandlerListener extends AbstractHook
{
    static protected function hooks(): array
    {
        return ['whoopsHandlers'];
    }

    public function __invoke(array $handlers): array
    {
        $handlers[] = new ioLoggerHandler();

        return $handlers;
    }
}
