<?php

declare(strict_types=1);

namespace apexl\Io\modules\logger\services;

use apexl\ClassEngine\Traits\Singleton;
use apexl\Io\modules\logger\dto\loggerConfig;
use apexl\Io\modules\logger\dto\streamConfig;
use apexl\Io\modules\logger\interfaces\loggerInterface;
use Exception;

class loggerStore
{
    use Singleton;

    /** @var loggerInterface[] */
    private array $streams = [];

    private loggerConfig $config;

    final public const DEFAULT__LOGGER_STREAM = 'default';
    final public const DEFAULT__ERROR_STREAM = 'error';

    protected function __construct()
    {
        try {
            $this->config = loggerConfig::fromConfig();
        } catch (Exception $e) {
            user_error(
                sprintf('Unable to access Config Singleton: %s', $e->getMessage()),
                E_USER_ERROR
            );

            exit;
        }
    }

    /**
     * @throws Exception
     */
    public function logger(string $stream = self::DEFAULT__LOGGER_STREAM): loggerInterface
    {
        if ($this->getStreamConfig($stream) === null) {
            error_log(sprintf('Unknown logger stream: %s', $stream), E_USER_WARNING);

            $stream = self::DEFAULT__LOGGER_STREAM;
        }

        if (!isset($this->streams[$stream])) {
            $this->streams[$stream] = $this->initStream($stream);
        }

        return $this->streams[$stream];
    }

    private function getStreamConfig(string $stream): ?streamConfig
    {
        return $this->config->streams[$stream] ?? null;
    }

    /**
     * @throws Exception
     */
    private function initStream(string $stream): loggerInterface
    {
        return new logger($stream, $this->getStreamConfig($stream));
    }
}
