<?php

declare(strict_types=1);

namespace apexl\Io\modules\logger\listeners;

use apexl\Io\includes\Hook;
use apexl\Io\modules\logger\whoops\handlers\ioLoggerHandler;

class whoopsHandlerListener
{
    private const HOOK = 'whoopsHandlers';

    public static function register()
    {
        Hook::registerCallback(
            self::HOOK,
            sprintf('%s:handle', whoopsHandlerListener::class)
        );
    }
    public static function handle(array $handlers): array
    {
        $handlers[] = new ioLoggerHandler();

        return $handlers;
    }
}
