<?php

declare(strict_types=1);

namespace apexl\Io\modules\logger\services\handlerCreator;

use apexl\Io\modules\logger\services\handlerCreator\handlerCreator;
use apexl\Vault\Vault;
use Monolog\Handler\ErrorLogHandler;
use Monolog\Handler\HandlerInterface;
use MySQLHandler\MySQLHandler;

class databaseLogHandlerCreator extends handlerCreator
{
    public function create(): HandlerInterface
    {
        $connection = Vault::getInstance()->getConnection();

        return new MySQLHandler(
            $connection,
            $this->handlerConfig->params->table,
            [],
            $this->level(),
        );
    }
}
